# -*- coding: utf-8 -*-
"""
VoicePad Voice Control Module

Hands-free voice commands:
- "Dictation start" -> Start recording
- "Dictation stop"  -> Stop recording
- "Dictation exit"  -> Close app
- "Dictation dark/light/frost" -> Change theme

Uses VOSK for 100% offline, always-on listening.
"""

from .controller import VoiceController
from .beep import (
    play_start_beep,
    play_stop_beep,
    play_error_beep,
    play_wake_beep,
    play_ready_beep,
)

__all__ = [
    "VoiceController",
    "play_start_beep",
    "play_stop_beep",
    "play_error_beep",
    "play_wake_beep",
    "play_ready_beep",
]
